function util_check_expire(expire_date=''){
    if(expire_date==''){
        return true;
    }
    expire_date = expire_date.replace('T00:00:00.000Z','');
    let now_date = new Date();
    expire_date_list = expire_date.split('-');
    expire_date_f = new Date(expire_date_list[0], (expire_date_list[1]-1), expire_date_list[2]);
    if (now_date > expire_date_f) {
        return true;
    }
    return false;
}

function util_check_is_maps_page(){
     //检测当前是否maps页面
    chrome.tabs.getSelected(null, function (tab) {
        var current_url =  tab.url;
        if(current_url){
            if(current_url.indexOf('qoo10')==-1){
                   chrome.tabs.create({ url: "https://www.qoo10.jp/" });
            }
        }else{
            chrome.tabs.create({ url: "https://www.qoo10.jp/" });
        }
    });
}

function get_expire(){
    var bg = chrome.extension.getBackgroundPage();
    bg.plugin_get_expire(function (callback_data){
        let expire_date = callback_data['expire'];
        if(typeof expire_date === 'undefined'){
            $('.jihuo').show();
            $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
            $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_qoo10_1nian&type=maijia_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
            return;
        }else{
            console.log('expire_date');
            console.log(expire_date);
            expire_date = expire_date.replace('T00:00:00.000Z','');
            $('#expire_date').html(expire_date);
            if (util_check_expire(expire_date)) {
                $('.jihuo').show();
                $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_qoo10_1nian&type=maijia_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                return;
            }
        }
    });
}

get_expire();

function extract_catalog_products_export_clean(){
    $('#extract-catalog-products-export-clean').click(function (){
         //
        $('#message-info').html('<span style="font-size: 12px;">提取需要花费时间，请保持界面不动,处理中...</span>')
        console.log('extract-catalog-products-url');
        //
        var bg = chrome.extension.getBackgroundPage();
        bg.storage_get(function (callback_data) {
            console.log('extract_catalog_products_export_clean');
            console.log(callback_data);
            //
            let expire_date = callback_data['expire'];
            if(typeof expire_date === 'undefined'){
                $('.jihuo').show();
                $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_qoo10_1nian&type=maijia_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                return;
            }else{
                console.log('expire_date');
                console.log(expire_date);
                expire_date = expire_date.replace('T00:00:00.000Z','');
                $('#expire_date').html(expire_date);
                if (util_check_expire(expire_date)) {
                    $('.jihuo').show();
                    $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                    $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_qoo10_1nian&type=maijia_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                    return;
                }
            }
            //
            let export_datas = [];
            for(let key in callback_data) {
                if (key.indexOf('shangjia_about_contact_and_basic_info_') != -1) {
                    let shangjia_about_contact_and_basic_info = callback_data[key];
                    let export_data_item = {
                        '产品': shangjia_about_contact_and_basic_info['_shangjia_name'],
                        '产品链接': shangjia_about_contact_and_basic_info['_shangjia_about_contact_and_basic_info_link'],
                        '发货国家': shangjia_about_contact_and_basic_info['_shangjia_shipping_country'],
                        '制造国': shangjia_about_contact_and_basic_info['_shangjia_made_country'],
                        '店铺名': shangjia_about_contact_and_basic_info['_shangjia_store_name'],
                        '店铺链接': 'https://www.qoo10.jp/shop/'+shangjia_about_contact_and_basic_info['_shangjia_id'],
                        '店铺产品数': shangjia_about_contact_and_basic_info['_shangjia_store_item_num'],
                        '公司名': shangjia_about_contact_and_basic_info['_shangjia_company'],
                        '公司地址': shangjia_about_contact_and_basic_info['_shangjia_address'],
                        '联系人': shangjia_about_contact_and_basic_info['_shangjia_faren'],
                        '电话': shangjia_about_contact_and_basic_info['_shangjia_phone'],
                        '邮箱': shangjia_about_contact_and_basic_info['_shangjia_email'],
                        '是否已采集':shangjia_about_contact_and_basic_info['_is_request'] ==2 ? '已采集':'未采集'
                    }
                    export_datas.push(export_data_item);
                }
            }
            //
            //console.log(export_datas);
            //
            exportToExcel(export_datas, 'gycharm-qoo10-export-'+Date.now(), "Sheet1");
            //
            //
            $('#message-info').html('');
            //
        });
        //
    });
}

extract_catalog_products_export_clean();

function extract_catalog_products_clean(){
    $('#extract-catalog-products-clean').click(function (){
        //
        if(confirm("确认清空吗？")){
            var bg = chrome.extension.getBackgroundPage();
            bg.storage_clear();
        }
        //
    });
}

extract_catalog_products_clean();
//
function extract_catalog_products_pause(){
    $('#extract-catalog-products-pause').click(function (){
        //
        var bg = chrome.extension.getBackgroundPage();
        bg.pause_switch(function (){
            bg.storage_get(function (callback_data) {
                if(callback_data.hasOwnProperty('pause') && callback_data['pause'] == 1){
                    $('#extract-catalog-products-pause').text('采集已暂停,可点击开启');
                }else{
                    $('#extract-catalog-products-pause').text('采集已开启,可点击暂停');
                }
            });
          //
        });
        //
    });
}
extract_catalog_products_pause();

function btn_pause_list_switch(){
    $('#btn-pause-list-switch').click(function (){
        var bg = chrome.extension.getBackgroundPage();
        bg.pause_list_switch(function (){
            bg.storage_get(function (callback_data) {
                if(callback_data['pause_list'] == 1){
                    $('#btn-pause-list-switch').text('列表采集已关闭,可点击开启');
                }else{
                    $('#btn-pause-list-switch').text('列表采集已开启,可点击暂停');
                }
            });
          //
        });
        //
    });
}
btn_pause_list_switch();

//
function data_process(){
    //$('#message-info').html('加载中...');
    var bg = chrome.extension.getBackgroundPage();
    //
    bg.get_data_process();
    //
    bg.data_process_get(function (callback_data) {
        //$('#message-info').html('');
        let data_process = callback_data['data_process'];
        let total_add_shangjia_num = 0;
        let has_caiji_geren_num = 0;
        let has_caiji_company_num = 0;
        let has_caiji_seller_num = 0;
        if(typeof data_process !== 'undefined' ){
            total_add_shangjia_num = data_process['total_add_shangjia_num'];
            has_caiji_geren_num = data_process['has_caiji_geren_num'];
            has_caiji_company_num = data_process['has_caiji_company_num'];
            has_caiji_seller_num = data_process['has_caiji_seller_num'];
            //
            $('#data_process').html("已添加<span>"+total_add_shangjia_num+"</span>个卖家,已采集<span>"+has_caiji_geren_num+"</span>个");
            //
        }
        //
    });
}
data_process();

setInterval(data_process, 3000);
//
function jihuo(){
    $('#jihuo_btn').click(function (){
        var jihuo_text = $('#jihuo_text').val();
        jihuo_text = jihuo_text.trim();
        $('#message-info').html('');
        if(jihuo_text==''){
            $('#message-info').html('<span style="color:red;">请输入激活码</span>');
            return;
        }
        //
        // other then GET
        let options = {
            method: 'GET',
            headers: {
                'Content-Type':'application/json;charset=utf-8'
            },
            //body: JSON.stringify(res)
        }
        // Fake api for making post requests
        let fetchRes = fetch( "https://api.gycharm.com/v1/plugin-chkpro/" + jihuo_text);
        fetchRes.then(res =>
            res.json()).then(d => {
                console.log('post response:');
                console.log(d);
                console.log(d['VAL']);
                //
                if (d['VAL'] === "NO_KEY") {
                    $('#message-info').html('<span style="color:red;">激活码不存在!</span>');
                }else if(d['VAL'] == 'HAS_BOUND'){
                    $('#message-info').html('<span style="color:red;">激活码已使用过!</span>');
                }else {
                    var expire_date = d['VAL'];
                    if (util_check_expire(expire_date) == false) {
                        var bg = chrome.extension.getBackgroundPage();
                        bg.plugin_set_expire(expire_date,function (){
                            expire_date = expire_date.replace('T00:00:00.000Z','');
                            $('#expire_date').html(expire_date);
                            $('.jihuo').hide();
                            $('#message-account-info').html('');
                        });
                      //
                    }else{
                        $('.jihuo').show();
                        $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                        $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_qoo10_1nian&type=maijia_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                        return;
                    }
                }
                //
            })
                //
    });
}
jihuo();

//
function init(){
    var bg = chrome.extension.getBackgroundPage();
    bg.storage_get(function (callback_data) {
        if(callback_data['pause'] == 1){
            $('#extract-catalog-products-pause').text('采集已暂停,可点击开启');
        }else{
            $('#extract-catalog-products-pause').text('采集已开启,可点击暂停');
        }
        $('#extract-catalog-products-pause').show();

        //列表页采集
        if(callback_data.hasOwnProperty('pause_list') && callback_data['pause_list'] == 1){
            $('#btn-pause-list-switch').text('列表页采集已关闭,可点击开启');
        }else{
            $('#btn-pause-list-switch').text('列表页采集已开启,可点击暂停');
        }
        //

    });
}
init();
//从content接收信息
chrome.runtime.onMessage.addListener((req, send, sendRes) => {
    console.log("收到info:", req.info)
    console.log("收到action:", req.action)
    console.log("收到tbm_map_urls:", req.maijia_num)

    if(req.action == 'update-shangjia-num'){
        var catalog_products_num = 0;
        var maijia_num = req.maijia_num;
        $('.catalog-products-num').html(maijia_num);
    }else if(req.action == 'background-tips'){
        //
        $('#message-info').html("<div style='color:red'>"+req.info+"</div>");
        //
    }

  })
//
//
document.getElementById("opnFacebook").addEventListener('click', function () {
  chrome.tabs.create({ url: "https://www.qoo10.jp/" });
})
//
//get columns
function getColumns(paramData){

	var header = [];
	$.each(paramData[0], function (key, value) {
		//console.log(key + '==' + value);
		var obj = {}
		obj["headertext"] = key;
		obj["datatype"] = "string";
		obj["datafield"] = key;
		header.push(obj);
	});
	return header;
}

//
function exportToExcel(data, fileName, sheetName) {
  // Create a new workbook
  var wb = XLSX.utils.book_new();

  // Convert your data to an array of arrays (2D array)
  var wsData = XLSX.utils.json_to_sheet(data);

  // Add the worksheet to the workbook
  XLSX.utils.book_append_sheet(wb, wsData, sheetName);

  // Generate the Excel file and trigger a download
  XLSX.writeFile(wb, fileName + ".xlsx");
}

function extract_product_lunbo_imgs(){
    $('#extract-product-lunbo-imgs').click(function (){
        $('#message-info').html('处理中...')
        console.log('extract-product-lunbo-imgs');
        // popup ---> content
        chrome.tabs.query({
            active: true,
            currentWindow: true
        }, (tabs) => {
            let message = {
                action: 'extract-product-lunbo-imgs',
                info: ''
            }
            chrome.tabs.sendMessage(tabs[0].id, message, res => {
                console.log('popup=>content')
                console.log(res)
                //
                $("#dvjson").excelexportjs({
                    containerid: "dvjson"
                       , datatype: 'json'
                       , dataset: res['product_wrap']
                       , columns: getColumns(res['product_wrap'])
                       , filename: res['product_name']
                });
                //
                //$('#message-info').html('完成,提取:'+res.length);
                //$('#message-info').html('完成')
            })
        })
        //
    });
}

extract_product_lunbo_imgs();

function extract_product_details_imgs(){
    $('#extract-product-details-imgs').click(function (){
        $('#message-info').html('处理中...')
        console.log('extract-product-details-imgs');
        // popup ---> content
        chrome.tabs.query({
            active: true,
            currentWindow: true
        }, (tabs) => {
            let message = {
                action: 'extract-product-details-imgs',
                info: ''
            }
            chrome.tabs.sendMessage(tabs[0].id, message, res => {
                console.log('popup=>content')
                console.log(res)
                //
                $("#dvjson").excelexportjs({
                    containerid: "dvjson"
                       , datatype: 'json'
                       , dataset: res['product_wrap']
                       , columns: getColumns(res['product_wrap'])
                       , filename: res['product_name']
                });
                //
                //$('#message-info').html('完成,提取:'+res.length);
                //$('#message-info').html('完成')
            })
        })
        //
    });
}

extract_product_details_imgs();