function util_check_expire(expire_date=''){
    if(expire_date==''){
        return true;
    }
    expire_date = expire_date.replace('T00:00:00.000Z','');
    let now_date = new Date();
    expire_date_list = expire_date.split('-');
    expire_date_f = new Date(expire_date_list[0], (expire_date_list[1]-1), expire_date_list[2]);
    if (now_date > expire_date_f) {
        return true;
    }
    return false;
}

function util_check_is_maps_page(){
     //检测当前是否maps页面
    chrome.tabs.getSelected(null, function (tab) {
        var current_url =  tab.url;
        if(current_url){
            if(current_url.indexOf('ozon')==-1){
                   chrome.tabs.create({ url: "https://www.ozon.com" });
            }
        }else{
            chrome.tabs.create({ url: "https://www.ozon.com" });
        }
    });
}

/**
 * 字典数组排序，只针对纯英文、数字或纯中文的排序
 * @param: dictArray 需要排序的字典数组
 * @param: sortKey  需要进行排序的键
 * @param: sortType asc升序(默认)  desc 降序
 **/
function util_dictArraySorting(dictArray,sortKey,sortType="asc"){
    if (sortType == 'asc'){
      dictArray.sort(function (dictA, dictB){
        return escape(dictA[sortKey]).indexOf("%u") < 0? dictA[sortKey] - dictB[sortKey]:dictA[sortKey].localeCompare(dictB[sortKey])
      })
    }
    if (sortType == 'desc'){
      dictArray.sort(function (dictA, dictB){
        return escape(dictA[sortKey]).indexOf("%u") < 0? dictB[sortKey] - dictA[sortKey]:dictB[sortKey].localeCompare(dictA[sortKey])
      })
    }
    return dictArray
}

function get_expire(){
    var bg = chrome.extension.getBackgroundPage();
    bg.plugin_get_expire(function (callback_data){
        let expire_date = callback_data['expire'];
        if(typeof expire_date === 'undefined'){
            $('.jihuo').show();
            $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
            $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_ozon_product_1nian&type=other_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
            return;
        }else{
            console.log('expire_date');
            console.log(expire_date);
            expire_date = expire_date.replace('T00:00:00.000Z','');
            $('#expire_date').html(expire_date);
            if (util_check_expire(expire_date)) {
                $('.jihuo').show();
                $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_ozon_product_1nian&type=other_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                return;
            }
        }
    });
}

get_expire();

function extract_catalog_products_export_clean(){
    $('#extract-catalog-products-export-clean').click(function (){
        util_check_is_maps_page();
        //
        $('#message-info').html('<span style="font-size: 12px;">提取需要花费时间，请保持界面不动,处理中...</span>')
        console.log('extract-catalog-products-url');
        //
        var bg = chrome.extension.getBackgroundPage();
        bg.storage_get(function (callback_data) {
            console.log('extract_catalog_products_export_clean');
            console.log(callback_data);
            //
            let expire_date = callback_data['expire'];
            if(typeof expire_date === 'undefined'){
                $('.jihuo').show();
                $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_ozon_product_1nian&type=other_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                return;
            }else{
                console.log('expire_date');
                console.log(expire_date);
                expire_date = expire_date.replace('T00:00:00.000Z','');
                $('#expire_date').html(expire_date);
                if (util_check_expire(expire_date)) {
                    $('.jihuo').show();
                    $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                    $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_ozon_product_1nian&type=other_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                    return;
                }
            }
            //
            let export_datas = [];
            //
            let shangjias_data = [];
            for(let key in callback_data){
                if(key.indexOf('shangjia_shangjia_item_url_') != -1){
                    let shangjia_shangjia_item_data = callback_data[key];
                    //if(shangjia_shangjia_item_data['_is_request'] && shangjia_shangjia_item_data['_seller_url_is_request'] && shangjia_shangjia_item_data['_seller_country'] != ''){
                         shangjias_data.push(callback_data[key]);
                    //}
                }
            }
            //
            let shangjias_new_data = util_dictArraySorting(shangjias_data, 'num', 'asc');
            //
            for(let i=0;i<shangjias_new_data.length;i++){
                //
                let shangjia_contact_info = shangjias_new_data[i];
                //
                let export_data_item = {
                    '商品url': shangjia_contact_info['_shangjia_item_url'],
                    '商品名': shangjia_contact_info['_name'],
                    //'商品sku': shangjia_contact_info['_sku'],
                    '商品售价': shangjia_contact_info['_price'],
                    '商品原价': shangjia_contact_info['_old_price'],
                    '评论分': shangjia_contact_info['_review_score'],
                    '评论数': shangjia_contact_info['_reivew_num'],
                    //'列表排名':shangjia_contact_info['_pos'],
                    //'图片': shangjia_contact_info['_img'],

                    //'卖家名':shangjia_contact_info['_seller_name'],
                    //'卖家网址':shangjia_contact_info['_seller_url'],
                    //'_seller_country':shangjia_contact_info['_seller_country'],
                    //'卖家公司名': shangjia_contact_info['_seller_company'],
                    //'卖家地址':shangjia_contact_info['_seller_address'],
                    //'企业/个人注册号ogrnip': shangjia_contact_info['_seller_ogrnip'],
                   // '查询企业详细信息': shangjia_contact_info['_seller_ogrnip']?"https://www.google.com/search?q="+shangjia_contact_info['_seller_ogrnip']:'',
                    //'是否中国企业':shangjia_contact_info['_is_china_maijia']==1?'是':'否',
                   // '省份':shangjia_contact_info['_sheng'],
                   // '原产国': shangjia_contact_info['_manufacturing_country'],
                    //'isPremium':shangjia_contact_info['isPremium'],
                    //'premium':shangjia_contact_info['premiumBtnText'],
                    //'品牌网址': shangjia_contact_info['_brand_url'],
                    //'品牌名': shangjia_contact_info['_brand_name'],

                    //'_is_request':shangjia_contact_info['_is_request'] == 2 ? '已采集': '未采集',
                    //'卖家是否重复':(shangjia_contact_info['_is_request'] == 2 && shangjia_contact_info['_seller_is_repeat'] == 1) ? '重复': ''
                }
                export_datas.push(export_data_item);
            }
            //
            exportToExcel(export_datas, 'gycharm-ozon-product-export-'+Date.now(), "Sheet1");
            //
            //
            $('#message-info').html('');
            //
        });
        //
    });
}

extract_catalog_products_export_clean();

function extract_catalog_products_clean(){
    $('#extract-catalog-products-clean').click(function (){
        if(confirm("确认清空吗?")){
            util_check_is_maps_page();
            //
            var bg = chrome.extension.getBackgroundPage();
            bg.storage_clear();
            //
        }
    });
}

extract_catalog_products_clean();
//
function data_process(){
    //$('#message-info').html('加载中...');
    var bg = chrome.extension.getBackgroundPage();
    //
    bg.get_data_process();
    //
    bg.data_process_get(function (callback_data) {
        //$('#message-info').html('');
        let data_process = callback_data['data_process'];
        let total_add_shangjia_num = 0;
        let has_caiji_shangjia_num = 0;
        if(typeof data_process !== 'undefined' ){
            total_add_shangjia_num = data_process['total_add_shangjia_num'];
            has_caiji_shangjia_num = data_process['has_caiji_shangjia_num'];
            //
            $('#data_process').html("已添加<span>"+total_add_shangjia_num+"</span>个商品,已采集<span>"+has_caiji_shangjia_num+"</span>个");
            //
        }
        //
    });
}
data_process();

setInterval(data_process, 3000);
//
function jihuo(){
    $('#jihuo_btn').click(function (){
        util_check_is_maps_page();
        var jihuo_text = $('#jihuo_text').val();
        jihuo_text = jihuo_text.trim();
        $('#message-info').html('');
        if(jihuo_text==''){
            $('#message-info').html('<span style="color:red;">请输入激活码</span>');
            return;
        }
        //
        // other then GET
        let options = {
            method: 'GET',
            headers: {
                'Content-Type':'application/json;charset=utf-8'
            },
            //body: JSON.stringify(res)
        }
        // Fake api for making post requests
        let fetchRes = fetch( "https://api.gycharm.com/v1/plugin-chkpro/" + jihuo_text);
        fetchRes.then(res =>
            res.json()).then(d => {
                console.log('post response:');
                console.log(d);
                console.log(d['VAL']);
                //
                if (d['VAL'] === "NO_KEY") {
                    $('#message-info').html('<span style="color:red;">激活码不存在!</span>');
                }else if(d['VAL'] == 'HAS_BOUND'){
                    $('#message-info').html('<span style="color:red;">激活码已使用过!</span>');
                }else {
                    var expire_date = d['VAL'];
                    if (util_check_expire(expire_date) == false) {
                        var bg = chrome.extension.getBackgroundPage();
                        bg.plugin_set_expire(expire_date,function (){
                            expire_date = expire_date.replace('T00:00:00.000Z','');
                            $('#expire_date').html(expire_date);
                            $('.jihuo').hide();
                            $('#message-account-info').html('');
                        });
                      //
                    }else{
                        $('.jihuo').show();
                        $('#expire_date').html("<span style='color:red;'>已过期或未激活</span>");
                        $('#message-info').html("<span style='color:red;'>已过期或未激活，</span><a href='https://www.gycharm.com/user/order-plugin?plugin=vip_ozon_product_1nian&type=other_plugin' target='_blank'>续费或者购买后，</a> <span style='color:red;'>在下面输入框激活！</span>");
                        return;
                    }
                }
                //
            })
                //
    });
}
jihuo();
//
function init(){
    var bg = chrome.extension.getBackgroundPage();
    bg.storage_get(function (callback_data) {
        //开启采集
        if(callback_data['pause'] == 1){
            $('#extract-catalog-products-pause').text('采集已暂停,可点击开启');
        }else{
            $('#extract-catalog-products-pause').text('采集已开启,可点击暂停');
        }
        $('#extract-catalog-products-pause').show();
        //自动翻页采集
        if(callback_data['pause_page'] == 1){
            $('#extract-catalog-products-pause-page').text('已关闭自动翻页采集,可点击开启');
        }else{
            $('#extract-catalog-products-pause-page').text('已开启自动翻页采集,可点击暂停');
        }
        $('#extract-catalog-products-pause-page').show();
        //
    });
}
init();
//
function extract_catalog_products_pause(){
    $('#extract-catalog-products-pause').click(function (){
        util_check_is_maps_page();
        //
        var bg = chrome.extension.getBackgroundPage();
        bg.pause_switch(function (){
            bg.storage_get(function (callback_data) {
                if(callback_data['pause'] == 1){
                    $('#extract-catalog-products-pause').text('采集已暂停,可点击开启');
                }else{
                    $('#extract-catalog-products-pause').text('采集已开启,可点击暂停');
                }
            });
          //
        });
        //
    });
}
extract_catalog_products_pause();

//
function extract_catalog_products_pause_page(){
    $('#extract-catalog-products-pause-page').click(function (){
        util_check_is_maps_page();
        //
        var bg = chrome.extension.getBackgroundPage();
        bg.pause_page_switch(function (){
            bg.storage_get(function (callback_data) {
                if(callback_data['pause_page'] == 1){
                    $('#extract-catalog-products-pause-page').text('已关闭自动翻页采集,可点击开启');
                }else{
                    $('#extract-catalog-products-pause-page').text('已开启自动翻页采集,可点击暂停');
                }
            });
          //
        });
        //
    });
}
extract_catalog_products_pause_page();
//从content接收信息
chrome.runtime.onMessage.addListener((req, send, sendRes) => {
    console.log("收到info:", req.info)
    console.log("收到action:", req.action)
    console.log("收到tbm_map_urls:", req.maijia_num)

    if(req.action == 'update-shangjia-num'){
        var catalog_products_num = 0;
        var maijia_num = req.maijia_num;
        $('.catalog-products-num').html(maijia_num);
    }else if(req.action == 'background-tips'){
        //
        $('#message-info').html("<div style='color:red'>"+req.info+"</div>");
        //
         //
        chrome.tabs.create({ url: req.url });
        //
    }

    //sendRes("popup已经收到")

  })
//
//
document.getElementById("opnFacebook").addEventListener('click', function () {
  chrome.tabs.create({ url: "https://www.ozon.com" });
})
//
//get columns
function getColumns(paramData){

	var header = [];
	$.each(paramData[0], function (key, value) {
		//console.log(key + '==' + value);
		var obj = {}
		obj["headertext"] = key;
		obj["datatype"] = "string";
		obj["datafield"] = key;
		header.push(obj);
	});
	return header;
}

function exportToExcel(data, fileName, sheetName) {
  // Create a new workbook
  var wb = XLSX.utils.book_new();

  // Convert your data to an array of arrays (2D array)
  var wsData = XLSX.utils.json_to_sheet(data);

  // Add the worksheet to the workbook
  XLSX.utils.book_append_sheet(wb, wsData, sheetName);

  // Generate the Excel file and trigger a download
  XLSX.writeFile(wb, fileName + ".xlsx");
}